#change to directory containing this file and run with:
# <KLayout install folder>\klayout_app.exe -r make_test_layout.py
# <KLayout install folder> may be:
#     ~\AppData\Roaming\KLayout
# or "C:\Program Files (x86)\KLayout"

import pya
import os

user = os.environ['USERNAME']

layout = pya.Layout()
layout.read('openEBL_splitter_template.gds')
target = layout.cell('splitter')

splitter = pya.Layout()
splitter.read('splitter_3d.gds')
src = splitter.cell('splitter')

target.copy_shapes(src)

top = layout.cell('openEBL_template')
top.name = 'openEBL_%s' % user

for shape in top.each_shape(layout.find_layer(10,0), pya.Shapes.STexts):
    shape.text_string = shape.text_string.replace('USERNAME', user)

layout.write('openEBL_%s.gds' % user)
